%------------------------------------------------------------------------------
% File     : LCL962^16 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Logic calculi
% Problem  : Proving disprovability
% Version  : [BP13] axioms.
% English  : If A can prove that B can prove p whenever it is true, and
%            if A can prove that B cannot prove p if that is true, and
%            if p is not true, then A can prove that p is not true.

% Refs     : [HA97]  Huima & Aura (1997), Using Multimodal Logic to Express
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : MML013+1 [QMLTP]

% Status   : Theorem 
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.10 v8.2.0, 0.23 v8.1.0
% Syntax   : Number of formulae    :   31 (  10 unt;  15 typ;   8 def)
%            Number of atoms       :   48 (   8 equ;   0 cnn)
%            Maximal formula atoms :    9 (   3 avg)
%            Number of connectives :   77 (   1   ~;   1   |;   4   &;  66   @)
%                                         (   1 <=>;   4  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   49 (  49   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   14 (  13 usr;   3 con; 0-3 aty)
%            Number of variables   :   31 (  21   ^;   9   !;   1   ?;  31   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $cumulative,
%            $modalities == $modal_system_S4].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mindex,type,
    mindex: $tType ).

thf(mrel_type,type,
    mrel: mindex > mworld > mworld > $o ).

thf('#b_type',type,
    '#b': mindex ).

thf('#a_type',type,
    '#a': mindex ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: mindex > ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ R @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: mindex > ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ R @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf('mrel_#b_reflexive',axiom,
    ! [W: mworld] : ( mrel @ '#b' @ W @ W ) ).

thf('mrel_#b_transitive',axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ '#b' @ W @ V )
        & ( mrel @ '#b' @ V @ U ) )
     => ( mrel @ '#b' @ W @ U ) ) ).

thf('mrel_#a_reflexive',axiom,
    ! [W: mworld] : ( mrel @ '#a' @ W @ W ) ).

thf('mrel_#a_transitive',axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ '#a' @ W @ V )
        & ( mrel @ '#a' @ V @ U ) )
     => ( mrel @ '#a' @ W @ U ) ) ).

thf(p_decl,type,
    p: mworld > $o ).

thf(ab_axiom_1,axiom,
    mlocal @ ( mbox @ '#a' @ ( mimplies @ p @ ( mbox @ '#b' @ p ) ) ) ).

thf(ab_axiom_2,axiom,
    mlocal @ ( mimplies @ ( mnot @ ( mbox @ '#b' @ p ) ) @ ( mbox @ '#a' @ ( mnot @ ( mbox @ '#b' @ p ) ) ) ) ).

thf(not_a_axiom_1,axiom,
    mlocal @ ( mnot @ p ) ).

thf(conj,conjecture,
    mlocal @ ( mbox @ '#a' @ ( mnot @ p ) ) ).

%------------------------------------------------------------------------------
